 
#include <Origin.h>
#include <Dialog.h>
#include "resource.h"

class TempConvDlg : public Dialog
{
public:
	TempConvDlg() : Dialog(IDD_TEMPCONV, "TempConv")
	{
		InitMsgMap();
	}

protected:
	
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_DESTROY(OnDestroy)
		ON_BN_CLICKED(IDC_C_TO_F, OnClickCToF)
		ON_BN_CLICKED(IDC_F_TO_C, OnClickFToC)
	EVENTS_END

	BOOL OnInitDialog()
	{
		m_ebCelsius = GetItem(IDC_CELSIUS);
		m_ebFahrenheit = GetItem(IDC_FAHRENHEIT);
		return TRUE;
	}
	
	BOOL OnDestroy()
	{
		return TRUE;
	}
		
	BOOL OnClickCToF(Control ctrl)
	{
		double dC = atof(m_ebCelsius.Text);
		double dF = dC * (9.0/5.0) + 32.0;
		m_ebFahrenheit.Text.Format("%f", dF);
		return TRUE;
	}

	BOOL OnClickFToC(Control ctrl)
	{
		double dF = atof(m_ebFahrenheit.Text);
		double dC = (dF - 32.0) * (5.0/9.0);
		m_ebCelsius.Text.Format("%f", dC);
		return TRUE;
	}

private:
	Edit m_ebCelsius;
	Edit m_ebFahrenheit;
};

static TempConvDlg s_tempconv;

int DoTempConvDlg()
{
	if( s_tempconv.GetWindow() )
	{
		s_tempconv.Close();
	}
	return s_tempconv.DoModal();
}
